// soundfx.c

#include "main.h"
#include "soundfx.h"
#include "midi.h"

SndChannelPtr soundChannel[5];
Handle sound[kNumSounds];
Boolean soundOn = true;
int channel[2] = {0, 0};

void InitSoundEffects( void )
{
	NumVersion version;
	short count;
	
	version = SndSoundManagerVersion( );
	if( version.majorRev >= 3 )
	{
		InitSoundChannel( &soundChannel[0], initChanLeft  );
		InitSoundChannel( &soundChannel[1], initChanLeft  );
		InitSoundChannel( &soundChannel[2], initChanRight );
		InitSoundChannel( &soundChannel[3], initChanRight );
		InitSoundChannel( &soundChannel[4], initStereo    );
		
		for( count = 0; count < kNumSounds; count++ )
		{
			sound[count] = GetResource( 'snd ', count+128 );
			if( sound[count] == nil )
				Error( errNoMemory, "\p(InitSoundEffects)" );
		
			HLockHi( sound[count] );
		}
	}
	else
	{
		soundOn = false;
		// DisableItem( GetMenuHandle( mOptions ), iSound );
	}
}

void InitSoundChannel( SndChannelPtr *soundChannel, short channelType )
{
	*soundChannel = nil;
	if( SndNewChannel( soundChannel, sampledSynth, channelType, nil ) != noErr )
		Error( errNoMemory, "\p(InitSoundChannel)" );
}

void PlayMono( short which )
{
	SndCommand soundCommand;
	int chan = 4;
		
	if( soundOn )
	{
		soundCommand.cmd = flushCmd;
		soundCommand.param1 = soundCommand.param2 = 0; // unused
		SndDoImmediate( soundChannel[chan], &soundCommand );
		
		soundCommand.cmd = quietCmd;
		soundCommand.param1 = soundCommand.param2 = 0; // unused
		SndDoImmediate( soundChannel[chan], &soundCommand );
		
		SndPlay( soundChannel[chan], (SndListHandle) sound[which], true );
	}
}

void PlayStereo( short player, short which )
{
	PlayStereoFrequency( player, which, 0 );
}

void PlayStereoFrequency( short player, short which, short freq )
{
	SndCommand soundCommand;
	int chan = (2*player) + channel[player];
	
	channel[player] = 1 - channel[player];
	
	if( soundOn )
	{
		soundCommand.cmd = flushCmd;
		soundCommand.param1 = soundCommand.param2 = 0; // unused
		SndDoImmediate( soundChannel[chan], &soundCommand );
		
		soundCommand.cmd = quietCmd;
		soundCommand.param1 = soundCommand.param2 = 0; // unused
		SndDoImmediate( soundChannel[chan], &soundCommand );
		
		SndPlay( soundChannel[chan], (SndListHandle) sound[which], true );
		
		soundCommand.cmd = rateMultiplierCmd;
		soundCommand.param1 = 0;
		soundCommand.param2 = 0x00010000 + (0x00001000 * freq);
		SndDoImmediate( soundChannel[chan], &soundCommand );
	}
}